module.exports = function (bh) {
    bh.match('b-teaser', function (ctx, json) {

        ctx.tag('table');
        ctx.tParam('model', json.model);
        ctx.content({
            tag: 'tbody',
            content: {
                tag: 'tr',
                content: [
                    {
                        elem: 'logo'
                    },
                    {
                        elem: 'description'
                    }
                ]
            }
        });
    });

    bh.match('b-teaser__logo', function (ctx) {
        var model = ctx.tParam('model');

        ctx.tag('th');
        ctx.content({
            block: 'b-link',
            url: model.url,
            content: {
                block: 'b-teaser',
                elem: 'icon',
                tag: 'img',
                attrs: {
                    src: model.imageUrl,
                    width: model.imageWidth
                }
            }
        });
    });

    bh.match('b-teaser__description', function (ctx) {
        var model = ctx.tParam('model');
        ctx.tag('td');

        ctx.content({
            block: 'b-link',
            url: model.url,
            content: model.text
        });
    });
};
