blocks.declare('b-user-settings', function (userSettingsData) {
    var items = [
        {
            url: userSettingsData.changeRegionUrl,
            type: 'change-region',
            text: BEM.I18N('b-user-settings', 'current-region', {
                region: userSettingsData.region
            })
        },
        userSettingsData.tuneDesktopVersionUrl && {
            url: userSettingsData.tuneDesktopVersionUrl,
            type: 'desktop-version',
            text: BEM.I18N('b-user-settings', 'desktop-version')
        },
        {
            url: userSettingsData.feedbackUrl,
            type: 'feedback',
            text: BEM.I18N('b-user-settings', 'feedback')
        },
        {
            url: userSettingsData.logoutUrl,
            type: 'exit',
            text: BEM.I18N('b-user-settings', 'exit')
        }
    ].map(function (item) {
            return {
                block: 'link',
                mix: {
                    block: 'b-user-settings',
                    elem: 'item',
                    mods: {
                        type: item.type
                    }
                },
                content: {
                    block: 'b-user-settings',
                    elem: 'inner-item',
                    content: item.text
                },
                url: item.url
            };
        });

    return {
        block: 'b-user-settings',
        js: 'true',
        content: items
    };
});
