blocks.declare('footer', function (data) {
    var i18n = BEM.I18N.bind(BEM.I18N, 'footer');
    return {
        block: 'footer',
        js: true,
        content: [
            {
                elem: 'column',
                content: [
                    {
                        block: 'copyright',
                        mix: {
                            block: 'footer',
                            elem: 'copyright'
                        },
                        start: 2008,
                        content: {
                            block: 'footer',
                            elem: 'link',
                            elemMods: {
                                inline: 'yes',
                                type: 'copyright'
                            },
                            url: bh.lib.services._uri.portal(data.nationalVersion),
                            content: i18n('copyright-title')
                        }
                    },
                    data.tuneDesktopVersionUrl && {
                        elem: 'link',
                        elemMods: {
                            inline: 'yes',
                            type: 'desktopVersion'
                        },
                        url: data.tuneDesktopVersionUrl,
                        content: i18n('desktop-version-title')
                    },
                    blocks.apply('b-mobile-lang-switcher', data.langSwitcher, {
                        block: 'footer',
                        elem: 'link'
                    }),
                    {
                        elem: 'link',
                        elemMods: {
                            type: 'feedback'
                        },
                        url: data.feedbackUrl,
                        content: i18n('feedback-title')
                    },
                    {
                        elem: 'link',
                        elemMods: {
                            type: 'user-agreement'
                        },
                        url: data.userAgreementUrl,
                        content: i18n('user-agreement-title')
                    }
                ]
            }
        ]
    };
});
