var Blocks = function () {
    this._methods = {};
};

Blocks.prototype = {
    declare: function (name, method) {
        this._methods[name] = method;
        return this;
    },

    get: function (name) {
        var method = this._methods[name];

        if (method) {
            return method;
        } else {
            throw new Error('Priv method ' + name + ' was not found');
        }
    },

    apply: function (name) {
        var args = Array.prototype.slice.call(arguments, 1),
            method = this._methods[name];

        if (method) {
            return method.apply(this, args);
        } else {
            throw new Error('Priv method ' + name + ' was not found');
        }
    }
};

this.blocks = new Blocks();
