# -*- coding: utf-8 -*-

from datetime import timedelta

from common.models.currency import Price, Currency


def can_buy_from(request, supplier_code, can_buy_context):
    if supplier_code != 'allticketsfor-me':
        return False

    if not can_buy_context['order_data']:
        return False

    too_late = (can_buy_context['segment'].departure - can_buy_context['now']) < timedelta(days=1)
    too_early = (can_buy_context['segment'].departure - can_buy_context['now']) > timedelta(days=90)

    if too_late or too_early:
        return False

    return True


def calc_final_price(price, currency_rates):
    if Currency.BASE_CURRENCY != 'RUR':
        return price

    if price.currency != 'EUR':
        return price

    price.base_value = None

    price += Price(2, 'EUR')

    if not currency_rates:
        return price

    rate = currency_rates.get('EUR')

    if rate is None:
        return price

    price.value = price.value * rate
    price.currency = 'RUR'

    price += Price(350, 'RUR')

    price.rebase(currency_rates)

    return price
