# -*- coding: utf-8 -*-


import re
import string
import sys
import random
from collections import defaultdict
from urllib import urlencode
from operator import itemgetter

from ammo.phantom import HttpCompiler
from common.models.schedule import Company

workflow_to_load_host = {
    'unstable': 't.rasp.rasp-front02g.load.rasp.yandex.ru',
    'testing': 't.rasp.rasp-front01g.load.rasp.yandex.ru'
}


def create_request(compiler, path='', attrs=None, body=None, tag=None):
    url = path
    if attrs:
        url += '?{}'.format(urlencode(attrs))
    return compiler.build_phantom(url, body=body, tag=tag)


def output_ammo(ammo, output_file=sys.stdout):
    total = 0
    for bullet in ammo:
        output_file.write(bullet)
        total += 1
    sys.stderr.write('generated {} bullets'.format(total))
    output_file.write('0\n')


def generate_ammo(items, host):
    headers = {
        'Host': host,
        'Connection': 'close',
    }
    compiler = HttpCompiler(method='GET', headers=headers)

    tags = set()
    for item in items:
        tags.add(item['tag'])

        yield create_request(
            compiler, path=item['path'],
            tag=item['tag']
        )


def create_bullets(items, workflow, ammo_file):
    print ammo_file

    ammo_generator = generate_ammo(
        items=items,
        host=workflow_to_load_host[workflow]
    )

    with open(ammo_file, 'w') as out:
        output_ammo(ammo_generator, out)
