# -*- coding: utf-8 -*-
import random
import string

from common.models.schedule import Company
from travel.rasp.touch.tools.bullets import create_bullets


def generate(workflow='unstable'):
    ids = [z.id for z in Company.objects.all()]
    set_ids = set(ids)
    ids404 = [id for id in range(0, 2*len(ids)) if id not in set_ids][len(ids) // 10:]  # добавим 404
    wrong_ids = [generate_random_string() for i in range(0, 100)]

    ids = ids + ids404 + wrong_ids

    items = [{'path': '/info/company/{id}/'.format(id=i),
              'tag': 'info/company/old'
             } for i in ids] + [{'path': '/info/company/{id}/?showOldPage=true'.format(id=i),
                                 'tag': 'info/company/new'
                                } for i in ids]

    create_bullets(items=items, workflow=workflow, ammo_file='company_ammo.txt')


def generate_random_string(n=5):
    return ''.join(random.choice(string.ascii_uppercase + string.digits) for _ in range(n))
