# -*- coding: utf-8 -*-

import os
import subprocess


def jscs_for_staged_files(jsfiles):
    print 'Запускаем jscs для следующих файлов:\n' + '\n'.join(jsfiles) + '\n'

    jscs_path = 'node_modules/jscs/bin/jscs'
    jscs_command = jscs_path + ' ' + ' '.join(jsfiles)

    print(jscs_command)

    return subprocess.call(jscs_command, shell=True)


def jshint_for_staged_files(jsfiles):
    print 'Запускаем hint для следующих файлов:\n' + '\n'.join(jsfiles) + '\n'

    jscs_path = 'node_modules/jshint/bin/jshint'
    jscs_command = jscs_path + ' ' + ' '.join(jsfiles)

    print(jscs_command)

    return subprocess.call(jscs_command, shell=True)


def lint():
    command_get_staged_js_files = "git diff --name-status HEAD | grep -v ^D | egrep '.js$' | cut -c3-"

    changed_js_files = [os.path.abspath(os.path.join('..', file_name))
                        for file_name in subprocess.Popen(command_get_staged_js_files,
                                                          shell=True,
                                                          stdout=subprocess.PIPE).stdout.read().split('\n')
                        if file_name]

    if not changed_js_files:
        print 'файлы не изменились'
        return

    if jshint_for_staged_files(changed_js_files):
        return

    if jscs_for_staged_files(changed_js_files):
        return


lint()
