# -*- coding: utf-8 -*-
from common.models.geo import Settlement
from common.models.transport import TransportType


def check_blablacar_allowed(search_type, point_from, point_to):
        # Список регионов, в которых не показываем Блаблакар, если и point_from, и point_to находятся в одном регионе
        forbidden_region_ids = [
            1,  # Москва и Московская обл.
            10174,  # СПб и Ленинградская обл.
            11079,  # Нижегорродская обл.
            11316,  # Новосибирская обл.
            21622,  # Минская обл.
            20544,  # Киев и Киевская обл.
            20538,  # Харьковская обл.
            11309,  # Красноярский край
        ]

        city_from = point_from if isinstance(point_from, Settlement) else getattr(point_from, 'settlement', None)
        region_from = city_from.region if city_from else None

        city_to = point_to if isinstance(point_to, Settlement) else getattr(point_to, 'settlement', None)
        region_to = city_to.region if city_to else None

        return (city_from and city_to and city_from.id != city_to.id and
                (search_type != 'suburban' or
                 not region_from or not region_to or region_from.id != region_to.id or
                 region_from.id not in forbidden_region_ids))


def pop_blablacar_row(segments):
    blablacar_segment = next((s for s in segments if s.t_type.id == TransportType.BLABLACAR), None)

    if blablacar_segment:
        segments.remove(blablacar_segment)
        return blablacar_segment

    return None
