def get_best_indexes_of_stations(from_station, to_station, path):
    if not from_station or not to_station:
        return 0, len(path) - 1

    variants = []
    current_from_i = None

    for i, node in enumerate(path):
        if from_station == node.station:
            current_from_i = i
            continue
        if not (current_from_i is None) and to_station == node.station:
            variants.append((current_from_i, i))

    return sorted(variants, key=lambda x: path[x[1]].tz_arrival - path[x[0]].tz_departure)[0]\
        if variants else (0, len(path) - 1)


def get_best_stations(from_station, to_station, rts_station_path):
    start, end = get_best_indexes_of_stations(from_station, to_station, rts_station_path)
    return rts_station_path[start], rts_station_path[end]
