# -*- coding: utf-8 -*-
from common.models.transport import TransportType
from common.xgettext.i18n import gettext


def get_plural_transport_by(code):
    if code == 'bus':
        return gettext(u'Автобусы')
    if code == 'train':
        return gettext(u'Поезда')
    if code == 'suburban':
        return gettext(u'Электрички')
    if code == 'plane':
        return gettext(u'Самолёты')
    if code == 'aeroex':
        return gettext(u'Аэроэкспрессы')
    if code in TransportType.WATER_TTYPE_CODES:
        return gettext(u'Теплоходы')
    if code == 'helicopter':
        return gettext(u'Вертолёты')

    return u''


def get_plural_station_name_by(code):
    if code == 'bus':
        return gettext(u'Автовокзалы')
    if code in ('train', 'suburban'):
        return gettext(u'Вокзалы')
    if code == 'plane':
        return gettext(u'Аэропорты')
    if code == 'aeroex':
        return gettext(u'Аэроэкспрессы')
    if code in TransportType.WATER_TTYPE_CODES:
        return gettext(u'Причалы')
    if code == 'helicopter':
        return gettext(u'Аэропорты')

    return u''
