# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import re
from typing import Optional


class TrainNumber(object):

    def __init__(self, digits, letters):
        # type: (int, unicode) -> None
        self.digits = digits
        self.letters = letters

    def serialize(self):
        return '{:03}{}'.format(self.digits, self.letters)

    def __eq__(self, other):
        if not isinstance(other, TrainNumber):
            return False

        return (
            self.digits == other.digits and
            self.letters == other.letters
        )

    def __repr__(self):
        return "<TrainNumber digits={} letters={}>".format(
            self.digits, self.letters
        )


class TrainNumberParser(object):
    """
    Парсер строковых нормер на две составляющие: цифры и буквы
    """
    train_number_re = re.compile(r'(\d+)(\D+)$')

    def parse(self, train_number):
        # type: (unicode) -> Optional[TrainNumber]
        match = self.train_number_re.match(train_number)
        if not match:
            return None

        number, letters = match.groups()
        letter = letters[0]

        return TrainNumber(int(number), letter)


train_number_parser = TrainNumberParser()


class TrainNumberReverser(object):
    """
    Преобразователь поездатого номера в обратный поездовый номер или прямой
    """
    def reverse(self, train_number):
        # type: (TrainNumber) -> TrainNumber

        train_digits = train_number.digits
        if train_digits % 2 == 0:
            train_digits -= 1
        else:
            train_digits += 1

        return TrainNumber(train_digits, train_number.letters)


train_number_reverser = TrainNumberReverser()
