# -*- coding: utf-8 -*-

from __future__ import unicode_literals
from django.utils.translation import get_language

from common.xgettext.i18n import gettext


class BEMBlock(object):
    pass


class ErrorDisclaimerBlock(BEMBlock):
    u"""Блок для дисклаймеров с ошибками"""

    def __init__(self, message):
        self.message = message

    def __json__(self):
        return {
            'block': 'b-message',
            'mods': {'type': 'null-search-result'},
            'content': {
                'elem': 'item',
                'content': self.message
            }
        }


class PreloaderBlock(BEMBlock):

    def __json__(self):
        return {
            'block': 'b-preloader',
            'content': [
                {
                    'block': 'spin',
                    'js': True,
                    'mods': {'progress': 'yes', 'theme': 'gray-24'}
                },
                gettext('обновление')
            ]
        }


class DetailsRouter(BEMBlock):

    def __init__(self, content, position_under=False):
        self.content = content
        self.position_under = position_under

    def __json__(self):
        elem_mods = {'type': 'attention'}

        if self.position_under:
            elem_mods['position'] = 'under'

        return {
            'block': 'b-details-router',
            'elem': 'line',
            'elemMods': elem_mods,
            'content': {
                'elem': 'description',
                'content': self.content
            }
        }


class DetailsAboutLocalTime():
    def __init__(self, position_under=False):
        self.position_under = position_under

    def __json__(self):
        if get_language() == 'tr':
            return None

        return DetailsRouter(gettext('Указано местное время'), self.position_under)
