# -*- coding: utf-8 -*-
from common.xgettext.i18n import xgettext, gettext, mark_gettext


class BuyAviaTicket(object):
    def __init__(self, buy_context):
        self.context = buy_context

    def state_loading(self):
        return {
            'elem': 'loader',
            'content': [
                {
                    'block': 'spin2',
                    'js': True,
                    'mods': {'size': 's', 'progress': 'yes'}
                },
                {
                    'elem': 'text',
                    'content': xgettext(u'Поиск цен продолжается')
                }
            ]
        }

    def state_not_found(self):
        return {
            'elem': 'not-found',
            'content': {
                'elem': 'text',
                'content': xgettext(u'Ничего не найдено')
            }
        }

    def state_form(self):
        v = self.context.variant
        return {
            'elem': 'form',
            'content': [
                {
                    'elem': 'head',
                    'content': [
                        {
                            'elem': 'title',
                            'content': xgettext(u'Лучшая цена')
                        },
                        {
                            'elem': 'description',
                            'content': xgettext(u'реклама')
                        }
                    ]
                },
                {
                    'elem': 'body',
                    'content': [
                        {
                            'elem': 'icon-container',
                            'content': {
                                'elem': 'icon',
                                'tag': 'image',
                                'attrs': {'src': v.logo}
                            }
                        },
                        {
                            'elem': 'label',
                            'content': v.partner_title
                        },
                        {
                            'block': 'button',
                            'mods': {
                                'theme': 'yellow',
                                'size': 'm'
                            },
                            'mix': [
                                {
                                    'block': 'b-avia-buy',
                                    'elem': 'button'
                                }
                            ],
                            'attrs': {
                                'target': '_blank'
                            },
                            'target': '_blank',
                            'url': v.deep_link or '/',
                            'content': xgettext(u'Купить')
                        },
                        {
                            'elem': 'price',
                            'content': v.tariff
                        }
                    ]
                }
            ]
        }

    def __json__(self):
        state = 'form'
        js = True

        if self.context.state == 'loading':
            state = 'loading'
            js = {
                'update-url': self.context.update_url
            }

        return {
            'block': 'b-avia-buy',
            'mods': {
                'state': state
            },
            'js': js,
            'content': [
                self.state_form(),
                self.state_loading(),
                self.state_not_found()
            ]
        }

mark_gettext('avia-disclaimer_search_ru')
mark_gettext('avia-disclaimer_search_ua')
mark_gettext('avia-disclaimer_thread_ru')
mark_gettext('avia-disclaimer_thread_ua')


class AviaDisclaimer(object):
    def __init__(self, national_version, hidden=False, keyset_type='search'):
        self.national_version = national_version
        self.hidden = hidden
        self.keyset_type = keyset_type

    def __json__(self):
        mods = None
        if self.hidden:
            mods = {
                'hidden': 'yes'
            }

        return {
            'block': 'b-avia-disclaimer',
            'mods': mods,
            'content': gettext('avia-disclaimer_{}_{}'.format(self.keyset_type, self.national_version))
        }
