# -*- coding: utf-8 -*-
from common.xgettext.i18n import xgettext


class BuyTrainTicket(object):
    def __init__(self, buy_context):
        self.context = buy_context

    def get_js_model(self):
        return {
            'buy_info_url': self.context.buy_info_url,
            'selected_item': self.context.selected_item,
            'partner_site': self.context.partner_site,
            'train_order_url_owner': self.context.train_order_url_owner
        }

    def get_js_item_model(self, variant):
        return {
            'result_text': variant.result_text,
            'code': variant.code,
            'choice': variant.choice,
            'train_order_url': variant.train_order_url
        }

    def class_item(self, variant, checked):
        data = self.get_js_item_model(variant)

        mods = {
            'name': variant.code
        }

        if checked:
            mods['checked'] = 'yes'

        return {
            'elem': 'item',
            'content': [
                {
                    'elem': 'type',
                    'tag': 'span',
                    'content': variant.name
                },
                {
                    'tag': 'button',
                    'block': 'b-radio-group',
                    'elem': 'item',
                    'elemMods': mods,
                    'js': {
                        'data': data
                    },
                    'mix': [{
                        'block': 'b-buy', 'elem': 'change-class-button'
                    }],
                    'content':  variant.tariff
                }
            ]
        }

    def e_result(self, selected_item):

        return {
            'elem': 'result',
            'content': [
                {
                    'elem': 'result-title',
                    'content': xgettext(u'Свободно:')
                },
                {
                    'elem': 'result-txt',
                    'content': selected_item.result_text
                }
            ]
        }

    def e_buy(self, owner):
        return {
            'block': 'b-link',
            'mix': [
                {
                    'block': 'b-buy',
                    'elem': 'button'
                }
            ],
            'content': xgettext(u'Купить на УФС') if owner == 'ufs' else xgettext(u'Выбрать место')
        }

    def e_coach_type(self, selected_item):
        return {
            'elem': 'coach-types',
            'content': [
                {
                    'elem': 'type',
                    'tag': 'span',
                    'content': selected_item.name
                },
                {
                    'elem': 'price',
                    'tag': 'span',
                    'content': selected_item.tariff
                }
            ]
        }

    def e_coach_types(self, selected, class_table):
        return {
            'elem': 'coach-types',
            'mix': {'block': 'b-radio-group', 'js': {
                'name': selected.code
            }},
            'content': {
                'elem': 'items',
                'content': [self.class_item(class_model, i == 0)
                            for i, class_model in enumerate(class_table)]
            }
        }

    def render_with_variants(self):
        selected_item = self.context.selected_item
        mods = {}

        if self.context.state == 'single-class':
            mods['type'] = 'single'

        return {
            'block': 'b-buy',
            'js': self.get_js_model(),
            'mods': mods,
            'content': {
                'elem': 'form',
                'tag': 'form',
                'content': [
                    self.context.state != 'single-class' and {
                        'elem': 'title',
                        'content': xgettext(u'Выберите тип вагона')
                    },
                    (
                        self.e_coach_types(self.context.selected_item, self.context.variants)
                        if self.context.state != 'single-class'
                        else self.e_coach_type(selected_item)
                    ),
                    self.e_result(selected_item),
                    self.e_buy(self.context.train_order_url_owner)
                ]
            }
        }

    def render_lazy_init(self):
        model = self.get_js_model()
        model['lazyInit'] = True
        return {
            'block': 'b-buy',
            'mods': {
                'type': 'next'
            },
            'js': model,
            'content': {
                'elem': 'form',
                'tag': 'form',
                'content': [
                    {
                        'block': 'spin2',
                        'js': True,
                        'mods': {'size': 's', 'progress': 'yes'}
                    },
                    {
                        'elem': 'text',
                        'content': xgettext(u'Проверяем наличие мест')
                    }
                ]
            }
        }

    def __json__(self):

        if self.context.state == 'lazy-init':
            return self.render_lazy_init()

        return self.render_with_variants()

