# -*- coding: utf-8 -*-

from travel.rasp.touch.touch.core.views.utils import get_attr_by_path


class CompanyIconModel(object):
    def __init__(self, png_url=None, svg_url=None):
        self.png_url = png_url
        self.svg_url = svg_url

    def union(self, other_icon):
        return CompanyIconModel(self.png_url or other_icon.png_url, self.svg_url or other_icon.svg_url)

    @staticmethod
    def get_icon_from_segment(segment):

        segment_icon = CompanyIconModel.empty

        route_icon = CompanyIconModel.empty
        if segment.thread:
            route_icon = CompanyIconModel.get_icon_from_thread(segment.thread)

        return segment_icon.union(route_icon)


    @staticmethod
    def get_icon_from_thread(thread):
        route_icon = CompanyIconModel.empty
        if getattr(thread, 'company', None):
            route_icon = CompanyIconModel.get_icon_from_company(thread.company)

        return route_icon

    @staticmethod
    def get_icon_from_company(company):
        png_icon_url = get_attr_by_path(company, 'icon.url', None)
        svg_icon_url = get_attr_by_path(company, 'svg_logo.url', None)

        return CompanyIconModel(png_icon_url, svg_icon_url)

CompanyIconModel.empty = CompanyIconModel()


class CompanyIconTemplate(object):
    def __init__(self, model):
        self.model = model

    def __json__(self):
        icons = []

        if self.model.png_url:
                icons.append({
                    'block': 'b-icon',
                    'mods': {'type': 'aviacompany', 'format': 'png'},
                    'src': self.model.png_url,
                    'width': '18'
                })

        if self.model.svg_url:
            icons.append({
                'block': 'b-icon',
                'mods': {'type': 'aviacompany', 'format': 'svg'},
                'src': self.model.svg_url,
                'width': '18'
            })

        if len(icons) == 1:
            icons[0]['mods']['force-show'] = 'yes'

        return icons


class CompanyLogoTemplate(object):
    def __init__(self, model):
        self.model = model

    def __json__(self):
        icons = []

        if self.model.png_url:
                icons.append({
                    'block': 'b-icon',
                    'mods': {'format': 'png'},
                    'src': self.model.png_url,
                    'width': '100px'
                })

        if self.model.svg_url:
            icons.append({
                'block': 'b-icon',
                'mods': {'format': 'svg'},
                'src': self.model.svg_url,
                'width': '100px'
            })

        if len(icons) == 1:
            icons[0]['mods']['force-show'] = 'yes'

        return icons
