# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import json

from django.conf import settings


def reach_goal_on(action, target, other_attrs=None, params=None):
    other_attrs = other_attrs or {}

    params = (', ' + json.dumps(params, ensure_ascii=False, indent=4)) if params else ''

    other_attrs['on' + action] = 'BEM.blocks["i-stat-counter"].reachGoal("{target}"{target_params}); return true;'.format(target=target, target_params=params)

    return other_attrs


def get_metrika(request):
    metrika_id = settings.METRIKA_IDS[request.tld]

    return '''
    <!-- Yandex.Metrika counter -->
    <script type="text/javascript">
    (function (d, w, c) {
        {%%metrika_debug%%}
        (w[c] = w[c] || []).push(function() {
            try {
                w.yaCounter = w.yaCounter{%%metrika_id%%} = new Ya.Metrika2({id:{%%metrika_id%%},
                        webvisor:true,
                        clickmap:true,
                        trackLinks:true,
                        accurateTrackBounce:true,
                        params: {%%metrika_params%%}
                        });
            } catch(e) { }
        });

        var n = d.getElementsByTagName("script")[0],
            s = d.createElement("script"),
            f = function () { n.parentNode.insertBefore(s, n); };
        s.type = "text/javascript";
        s.async = true;
        s.src = (d.location.protocol == "https:" ? "https:" : "http:") + "//mc.yandex.ru/metrika/tag.js";

        if (w.opera == "[object Opera]") {
            d.addEventListener("DOMContentLoaded", f, false);
        } else { f(); }
    })(document, window, "yandex_metrika_callbacks2");
    </script>
    <noscript><div><img src="//mc.yandex.ru/watch/{%%metrika_id%%}" style="position:absolute; left:-9999px;" alt="" /></div></noscript>
    <!-- /Yandex.Metrika counter -->
    '''.replace('{%%metrika_id%%}', str(metrika_id))\
        .replace('{%%metrika_debug%%}', 'w._ym_debug=1;' if settings.DEBUG_METRIKA else '')\
        .replace('{%%metrika_params%%}', json.dumps({
            'isLogin': request.yauser.is_authenticated()
        }))

