# -*- coding: utf-8 -*-

numberToString = {
    2: 'two',
    3: 'three',
    4: 'four',
}


class SwitcherTemplate(object):
    def __init__(self, value, items, mods=None, url=None, param_name=None):
        self.items = items

        self.mods = {
            'count': numberToString[len(self.items)]
        }

        self.value = value

        self.mods.update(mods or {})
        js = {'value': value, 'paramName': param_name}
        if url:
            js['url'] = url

        self.js = js

    def __json__(self):
        return {
            'block': 'b-switcher',
            'mods': self.mods,
            'js': self.js,
            'content': [self._button(self.items[0], position='left')] +
                       [self._button(m, position='middle') for m in self.items[1: -1]] +
                       [self._button(self.items[-1], position='right')]
        }

    def _button(self, model, position):
        button_mods = {
            'position': position
        }

        if self.value == model['js']['value']:
            button_mods.update({'checked': 'yes'})

        return {
            'elem': 'button',
            'elemMods': button_mods,
            'js': model['js'],
            'content': {
                'elem': 'text',
                'content': model['text']
            }
        }


