# -*- coding: utf-8 -*-
from common.xgettext.i18n import dynamic_gettext
from travel.rasp.touch.tariffs import CLS_SHORT_NAMES
from travel.rasp.touch.touch.core.templates.utils import currency


class TariffPrice:
    def __init__(self, place, currency_info, type_tariff,  national_version=None):
        self.place = place
        self.currency_info = currency_info
        self.national_version = national_version
        self.type_tariff = type_tariff

    def __json__(self):
        return {
            'block': 'b-routers',
            'elem': 'price',
            'elemMods': {'type': self.type_tariff},
            'content': [
                self.place.code in CLS_SHORT_NAMES and {
                    'block': 'b-routers',
                    'elem': 'place',
                    'content': dynamic_gettext(CLS_SHORT_NAMES[self.place.code]) if self.national_version != 'tr' else ' '
                },
                self.place.tariff > 0 and {
                    'block': 'b-routers',
                    'elem': 'price',
                    'content': currency(self.place.tariff, self.currency_info, getattr(self.place, 'min', False))
                },
            ]
        }
