# -*- coding: utf-8 -*-

from __future__ import unicode_literals
from common.utils.locations import composeurl

from common.xgettext.i18n import gettext, xgettext

from travel.rasp.touch.touch.core.templates.base import Base
from travel.rasp.touch.touch.core.templates.blocks.switcher import SwitcherTemplate
from travel.rasp.touch.touch.core.views.utils import get_attr_by_path
from .blocks import ErrorDisclaimerBlock, DetailsRouter, DetailsAboutLocalTime
from .form import DirectionSearchFormRenderer
from .search.search import TimetableBlock
from .utils import currency


class Template(Base):
    page = 'direction'
    show_calendar = True

    def head_content_extended(self):
        return [{'elem': 'meta', 'attrs': {'name': 'apple-itunes-app', 'content': 'app-id=387272416'}}]

    def content(self):
        return [
            self.alarm(),
            {
                'elem': 'item',
                'content': [
                    DirectionSearchFormRenderer(self.context.form, self, show_cancel=False),
                ]
            },
        ]


class SearchTemplate(Base):
    page = 'direction'
    show_calendar = True

    def __init__(self, request, view_context):
        super(SearchTemplate, self).__init__(request, view_context)

        segments = self.context.segments

        self.segments = segments

        self.has_gone = any([r.gone for r in segments])
        self.has_actual = any([not r.gone for r in segments])

        self.show_gone = self.has_gone and not self.has_actual

        self.show_only_aeroexpress = 'aeroex' in self.context.request.GET and \
            set([get_attr_by_path(segment, 'thread.is_aeroexpress', False)
                 for segment in self.segments]) == {True, False}

        if self.context.form['all_days'].data or (self.has_gone and not self.has_actual) or \
                (not self.has_gone and self.has_actual) or \
                (not self.has_gone and not self.has_actual):
            self.show_hidden_button = False

        else:
            self.show_hidden_button = True

    def not_found_message(self):
        return gettext(u'По данному направлению рейсов не найдено')

    def b_routers(self):
        if not self.segments:
            return ErrorDisclaimerBlock(self.not_found_message())

        all_days_search = self.context.form['all_days'].data

        t_block = TimetableBlock(self,
                                 show_time_left=False,
                                 show_time_icons=False, show_company_icon=False,
                                 show_tariffs_column=True,
                                 mods={'suburban': 'yes'},
                                 show_date_if_changed=not all_days_search,
                                 hide_gones=not all_days_search,
                                 js_params={'all_days': all_days_search},
                                 show_stops=all_days_search,
                                 show_days=all_days_search)

        return t_block

    def extended_notice(self):
        if self.context.segments and self.context.extended:
            message = xgettext('Прямых рейсов <request-direction/> не найдено. Предлагаем вам результат поиска <display-direction/>.',
                               request_direction="%s — %s" % (self.context.requested_from.L_title_with_prefix(), self.context.requested_to.L_title_with_prefix()),
                               display_direction="%s — %s" % (self.context.point_from.L_title_with_prefix(), self.context.point_to.L_title_with_prefix()),)

            return ErrorDisclaimerBlock(message)

    def content(self):
        show_cancel = bool(self.segments)
        form_renderer = DirectionSearchFormRenderer(self.context.form, self, True, show_cancel=show_cancel)

        return [
            self.alarm(),
            {
                'elem': 'item',
                'elemMods': {'type': 'form-container'},
                'content': [
                    {
                        'block': 'b-transport-head',
                        'content': [{
                            'elem': 'title',
                            'content': gettext('Электрички')
                        }]
                    },
                    form_renderer.collapsed(),
                    form_renderer,
                    {
                        'block': 'grid',
                        'mods': { 'layout': 'table', 'width': 'full' },
                        'content': {
                            'elem': 'row',
                            'content': [
                                {
                                    'elem': 'col',
                                    'content': {
                                        'block': 'b-action-button',
                                        'mods': {
                                            'type': 'filter'
                                        }
                                    }
                                },
                                {
                                    'elem': 'col',
                                    'elemMods': {
                                        'type': 'hungry'
                                    },
                                    'content': SwitcherTemplate(value=self.context.form.cleaned_data['mode'],
                                                                items=self.get_switcher_items(),
                                                                param_name='mode',
                                                                mods={'switch': 'date-mode'})
                                }
                            ]
                        }
                    }
                ]
            },
            {
                'elem': 'item',
                'content': [
                    {
                        'block': 'error-message',
                        'content': ''
                    },
                    self.extended_notice(),
                    DetailsAboutLocalTime()
                ]
            },
            self.b_routers(),
        ]

    def get_switcher_items(self):
        return [
            {
                'js': {'value': 'nearest'},
                'text': gettext(u'Ближайшие'),
            },
            {
                'js': {'value': 'today'},
                'text': gettext(u'Сегодня')
            },
            {
                'js': {'value': 'all_days'},
                'text': gettext(u'Все')
            }
        ]
