# -*- coding: utf-8 -*-

from common.utils.date import NBSP
from common.xgettext.i18n import gettext
import settings

from travel.rasp.touch.touch.core.views.utils import get_transport_code_from
from ..utils import wrap_with_span_item


def build_schedule_line_info(t_code, schedule_line, national_version=None):
    return {
        'elem': 'info',
        'content': _info(t_code=t_code,
                         number=schedule_line.number,
                         company=getattr(schedule_line.thread, 'company', None),
                         has_eticket=False,
                         national_version=national_version) + _extra_info(thread=schedule_line.thread)
    }


def build_thread_line_info(t_code, thread, national_version=None):
    return {
        'elem': 'info',
        'content': _info(t_code=t_code,
                         number=thread and thread.number,
                         company=thread and thread.company,
                         has_eticket=False,
                         national_version=national_version) + _extra_info(thread=thread)
    }


def build_segment_line_info(segment, national_version=None):
    has_eticket = False
    tariffs_info = segment.display_info.get('tariffs_info')

    if tariffs_info:
        has_eticket = bool(tariffs_info.et_marker)

    return {
        'elem': 'info',
        'content': _info(t_code=get_transport_code_from(segment),
                         number=segment.number,
                         company=segment.company,
                         has_eticket=has_eticket,
                         national_version=national_version) + _extra_info(thread=segment.thread)
    }


def _info(t_code, number, company, has_eticket, national_version=None):
    content = [{
        'block': 'b-icon-carrier',
        'mods': {
            'type': t_code
        }
    }]

    tablo_name = [{
        'elem': 'number-transport',
        'elemMods': {'type': has_eticket and 'ticket-ico'},
        'content': number
    }]

    if company:
        tablo_name += [" ", {
            'elem': 'company',
            'content': company.L_short_title() or company.L_title()
        }]

    if national_version == 'tr' and t_code == 'train':
        tablo_name.reverse()

    content += tablo_name

    return content


def _extra_info(thread):
    if not thread:
        return []

    if thread.type.code == 'through_train':
        return [
            NBSP, {
                'elem': 'span',
                'content': gettext(u'беспересадочный вагон')
            }
        ]

    if thread.L_title_special():
        return [
            NBSP, {
                'elem': 'title-special',
                'content': wrap_with_span_item(u'«' + thread.L_title_special() + u'»')
            }
        ]

    if thread.is_deluxe:
        return [
            NBSP, {
                'elem': 'title-special',
                'content': gettext(u'фирменый')
            }
        ]

    if thread.express_lite:
        express_lite = thread.express_lite
        return [
            NBSP, {
                'elem': 'title-special',
                'attrs': {'style': 'color: %s' % express_lite.color},
                'content': express_lite.title.replace(' ', NBSP)
            }
        ]

    if thread.is_express:
        return [
            NBSP, {
                'elem': 'title-special',
                'attrs': {'style': 'color: %s' % settings.EXPRESS_COLOR},
                'content': gettext(u'экспр.')
            }
        ]

    return []
