# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from .base import Base
from .form import SearchFormRenderer, DirectionSearchFormRenderer
from .blocks import ErrorDisclaimerBlock


class Template(Base):
    page = 'search-result-electric-train'
    form_renderer = SearchFormRenderer

    def __init__(self, request, context, show_calendar=True):
        self.show_calendar = show_calendar
        super(Template, self).__init__(request, context)

    def content(self):
        return [
            self.context.form and {
                'elem': 'item',
                'content': self.form_renderer(self.context.form, self, show_cancel=False)
            },
            {
                'elem': 'item',
                'content': ErrorDisclaimerBlock(self.context.error)
            }
        ]


class DirectionTemplate(Template):
    form_renderer = DirectionSearchFormRenderer
