# coding: utf8

from __future__ import unicode_literals

from django.conf import settings
from django.http import HttpResponse
from django.utils.translation import get_language

from common.utils import request_helper
from common.utils.ya import get_change_language_url, get_country_by_lang

from travel.rasp.touch.touch.core.templates.utils import tune_desktop_alternate_link, desktop_version_link
from travel.rasp.touch.touch.core.templates.utils.bh import render
from travel.rasp.touch.touch.core.templates.utils.favicons import get_favicons
from travel.rasp.touch.touch.core.templates.utils.tizer import teaser_info
from travel.rasp.touch.touch.core.templates.utils.touch_links import feedback_url, user_agreement_url, alternative_urls, auth_url


def build_urls(request):

    return {
        'desktopVersionUrl': desktop_version_link(request),
        'tuneDesktopVersionUrl': tune_desktop_alternate_link(request),
        'feedbackUrl': feedback_url(request),
        'userAgreementUrl': user_agreement_url(request),
        'alternativeUrls': alternative_urls(request)
    }


def build_global(request):
    absolute_url = request_helper.build_absolute_uri(request)
    return {
        'rasp-url': settings.RASP_URL,
        'static-host': settings.MARKUP_URL,
        'touch-url': settings.TOUCH_URL,
        'url': absolute_url,
        'retpath': absolute_url,
        'suggests-domain': settings.SUGGESTS_DOMAIN,
        'client-city-geo-id': request.client_city._geo_id,
        'suggests-limit': settings.SUGGESTS_LIMIT,
        'lang': request.LANGUAGE_CODE,
        'nationalVersion': request.NATIONAL_VERSION,
        'isLogin': request.yauser.is_authenticated(),
        'uid': request.yauser.uid and str(request.yauser.uid),
        'login': request.yauser.login if request.yauser.uid else None,
        'content-region': request.NATIONAL_VERSION
    }


def build_lang_switcher(request):
    if len(request.supported_langs) < 2:
        return None

    langs = request.supported_langs
    current_lang = get_language()

    variants = [{'url': get_change_language_url(request, lang) if current_lang != lang else None,
                 'lang': lang} for lang in langs]

    return {
        'country': get_country_by_lang(current_lang),
        'variants': variants
    }


def build_user_settings_model(request):
    return {
        'region': request.client_city.L_title(),
        'changeRegionUrl': request.change_region_url,
        'tuneDesktopVersionUrl': tune_desktop_alternate_link(request),
        'feedbackUrl': feedback_url(request),
        'logoutUrl': auth_url(request)
    }


def build_page(request, page_name, view_contract, lang=None):
    lang = lang or get_language()

    contract = {
        'user': {
            'lang': lang,
            'uid': request.yauser.uid and str(request.yauser.uid),
            'login': request.yauser.login if request.yauser.uid else None,
        },
        'stHost': settings.MARKUP_URL,
        'lang':  lang,
        'tld':  request.tld,
        'nationalVersion': request.NATIONAL_VERSION,
        'metrikaId': settings.METRIKA_IDS[request.tld],
        'metrikaParams': {
            'isLogin': request.yauser.is_authenticated()
        },
        'DEBUG':  settings.DEBUG,
        'urls': build_urls(request),
        'teaser': teaser_info(request),
        'favicons': get_favicons(request, settings.PROJECT_PATH),
        'global': build_global(request),
        'langSwitcher': build_lang_switcher(request),
        'userSettings': build_user_settings_model(request)
    }

    contract.update(view_contract)

    html = render(page_name, contract, lang)

    response = HttpResponse(html, content_type="text/html")
    response['X-Frame-Options'] = 'Deny'

    return response
