# -*- coding: utf-8 -*-

from common.xgettext.i18n import gettext
from travel.rasp.touch.touch.core.templates.blocks.tariffPrice import TariffPrice

from .utils import currency


def plane_tariff_places(places, currency_info=None):
    return [(
        {
            'block': 'b-routers',
            'elem': 'price',
            'content': currency(place.tariff, currency_info, getattr(place, 'min', False))
        },
        {
            'block': 'b-routers',
            'elem': 'button',
            'content': {
                'block': 'button',
                'mods': {
                    'theme': 'yellow',
                    'size': 's'
                },
                'attrs': {
                    'target': '_blank'
                },
                'url': place.deep_link,
                'content': gettext(u'Купить')
            }
        }
    ) for place in places]


def tariffs_places(places, currency_info=None, national_version=None):
    return [TariffPrice(place, currency_info, 'train', national_version=national_version) for place in places]
