# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from django.utils.translation import get_language

from common.utils.locations import composeurl
from common.xgettext.i18n import gettext, xgettext

from travel.rasp.touch.touch.core.templates.base import Base
from .utils import wrap_with_link_item


class Template(Base):
    page = 'search-result-on-name-station'

    def line(self, variant):
        form = self.context.form
        data = self.context.data
        field_name = self.context.field
        params = {
            'when': form.get_when()
        }

        if field_name == 'from':
            params.update({
                'fromName': variant.L_title(),
                'fromId': variant.point_key,
                'toName': form['toName'].data,
                'toId': form['toId'].data
            })

        else:
            params.update({
                'fromName': form['fromName'].data,
                'fromId': form['fromId'].data,
                'toName': variant.L_title(),
                'toId': variant.point_key
            })

        if self.context.validationOff:
            params['validationOff'] = data.validationOff

        if self.context.search_type:
            params['search_type'] = self.context.search_type

        # пришли из поиска по электричкам
        if self.context.type == 'direction_search':
            request = self.context.request

            if data.when == 'на все дни' or request.GET.get('all_days'):
                params['all_days'] = '1'

            params['direction'] = data.direction.code or ''
            params = dict((k, v) for k, v in params.iteritems() if v)

            url = composeurl('direction_search', params=params)

        else:
            if self.context.search_type:
                kwargs = {'search_params': self.context.type}
                view_name = 'search'

            else:
                kwargs = {}
                view_name = 'main_search'

            params = dict((k, v) for k, v in params.iteritems() if v)
            url = composeurl(view_name=view_name, kwargs=kwargs, params=params)

        national_version = self.context.request.NATIONAL_VERSION
        show_district = national_version == 'ru'
        full_title = variant.L_omonim_title(show_district=show_district, national_version=national_version)

        return {
            'elem': 'line',
            'mix': [{'block': 'i-pressed-controller'}],
            'content': [{
                'elem': 'item',
                'content': [
                    {
                        'block': 'b-link',
                        'url': url,
                        'content': [{
                            'elem': 'item',
                            'content': full_title['title']
                        }]
                    },
                    {
                        'elem': 'location',
                        'content': wrap_with_link_item(full_title['add'])
                    }
                ]
            }]
        }

    def content(self):
        field_name = self.context.field

        if field_name == 'from':
            header = gettext('Пожалуйста, уточните место отправления:')

        else:
            header = gettext('Пожалуйста, уточните место прибытия:')

        return [{
            'elem': 'item',
            'content': [
                {
                    'block': 'b-title',
                    'mods': {'size': 'small'},
                    'content': header
                },
                {
                    'block': 'b-routers',
                    'mods': {'type': 'search-result'},
                    'content': [self.line(variant) for variant in self.context.variants]
                }
            ]
        }]


class ChooseCountryStation(Base):
    page = 'search-result-on-name-station'

    def lines(self, variant):
        form = self.context.form
        field_name = self.context.field
        city = variant[0]
        stations = variant[1]

        params = {
            'when': '' if form.is_now_today() else form.get_when()
        }

        lines = []

        if len(stations) == 1:
            point = stations[0]

        else:
            point = city

            for station in stations:
                if field_name == 'from':
                    params.update({
                        'fromName': station.L_title(),
                        'fromId': station.point_key,
                        'toName': form['toName'].data,
                        'toId': form['toId'].data
                    })

                else:
                    params.update({
                        'fromName': form['fromName'].data,
                        'fromId': form['fromId'].data,
                        'toName': station.L_title(),
                        'toId': station.point_key
                    })

                params = dict((k, v) for k, v in params.iteritems() if v)
                url = composeurl('main_search', params=params)

                lines.append({
                    'elem': 'line',
                    'mix': [{'block': 'i-pressed-controller'}],
                    'content': [{
                        'elem': 'item',
                        'mods': {'stage': 'two'},
                        'content': [{
                            'block': 'b-link',
                            'url': url,
                            'content': [{
                                'elem': 'item',
                                'content': xgettext('а/п <station/>', station=station.L_title)
                            }]
                        }]
                    }]
                })

        if field_name == 'from':
            params.update({
                'fromName': city.L_title(),
                'fromId': point.point_key,
                'toName': form['toName'].data,
                'toId': form['toId'].data
            })

        else:
            params.update({
                'fromName': form['fromName'].data,
                'fromId': form['fromId'].data,
                'toName': city.L_title(),
                'toId': point.point_key
            })

        params = dict((k, v) for k, v in params.iteritems() if v)
        url = composeurl('main_search', params=params)

        lines.insert(0, {
            'elem': 'line',
            'mix': [{'block': 'i-pressed-controller'}],
            'content': [{
                'elem': 'item',
                'content': [
                    {
                        'block': 'b-link',
                        'url': url,
                        'content': [{
                            'elem': 'item',
                            'content': xgettext('г. <city/>', city=city.L_title)
                        }]
                    },
                ]
            }]
        })

        return lines

    def content(self):
        variants = self.context.airports
        country = self.context.country

        if self.context.field == 'from':
            if get_language() == 'ru':
                header = xgettext('Пожалуйста, уточните пункт отправления <country-title case="phrase_in"/>:',
                                  country_title=country.L_title)

            else:
                header = gettext('Пожалуйста, уточните пункт отправления.')

        else:
            if get_language() == 'ru':
                header = xgettext('Пожалуйста, уточните пункт прибытия <country-title case="phrase_in"/>:',
                                  country_title=country.L_title)

            else:
                header = gettext('Пожалуйста, уточните пункт прибытия.')

        lines = []

        for variant in variants:
            lines += self.lines(variant)

        return [{
            'elem': 'item',
            'content': [
                {
                    'block': 'b-title',
                    'mods': {'size': 'small'},
                    'content': header
                },
                {
                    'block': 'b-routers',
                    'mods': {'type': 'search-result'},
                    'content': lines
                }
            ]
        }]
