# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.xgettext.i18n import gettext
from travel.rasp.touch.touch.core.helpers.transport_type import get_plural_transport_by

from travel.rasp.touch.touch.core.templates.blocks import DetailsAboutLocalTime
from travel.rasp.touch.touch.core.templates.search.search import TimetableTemplate, TimetableBlock


class UntypedTimetableBlock(TimetableBlock):
    def format_filter_station_name(self, station):
        return station.L_title_with_type()


class UntypedTimetableTemplate(TimetableTemplate):
    page = 'search-result.tr'
    timetable_block_class = UntypedTimetableBlock

    def body(self):
        return [{
            'elem': 'item',
            'content': [
                {
                    'block': 'error-message',
                    'content': ''
                }
            ]
        },
            self.b_tabs(),
            self.b_routers()
        ]

    def b_tabs(self):
        groups = self.context.groups

        if not groups:
            return None

        return {
            'block': 'b-tabs-modern',
            'js': True,
            'content': [self.b_tabs_item(key) for key in groups.iterkeys()]
        }

    def b_tabs_item(self, ttype):
        return {
            'elem': 'item',
            'elemMods': {
                'state': 'active'
            },
            'js': {'type': ttype},
            'content': [{
                'block': 'b-icon-carrier',
                'mods': {
                    'type': ttype
                }
            }, {
                'elem': 'text',
                'content': get_plural_transport_by(ttype)
            }]
        }
