# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.models.transport import TransportType
from common.utils.avia import get_avia_thread_url
from common.utils.locations import composeurl, langify


def get_station_thread_url(thread, departure, request):
    if thread.t_type_id == TransportType.PLANE_ID:
        return get_avia_thread_url(thread, request.tld,  day=departure,
                                   utm_medium='station_landing', utm_campaign='flight_link')
    return composeurl('thread', kwargs={'uid': thread.uid}, params={'departure': departure.strftime('%Y-%m-%d')})
