# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.utils.locations import composeurl, langify
from common.xgettext.i18n import xgettext, gettext, mark_gettext

from travel.rasp.touch.touch.core.templates.base import Base
from travel.rasp.touch.touch.core.templates.blocks.metrika import reach_goal_on
from travel.rasp.touch.touch.utils import get_station_url

FROM_AIRPORT_TO_CITY_TEMPLATE = mark_gettext('а/п <point-from/> - <point-to/>')
FROM_CITY_TO_AIRPORT = mark_gettext('<point-from/> - а/п <point-to/>')


class Template(Base):
    page = 'index-transport-select'

    def transport_points(self):
        stations = self.context.stations

        if self.context.aeroex:
            content = []

            for station in stations:
                city = station.settlement

                content.append(aeroexpress_direction_link(from_point=city,
                                                          to_point=station,
                                                          template=FROM_CITY_TO_AIRPORT))
                content.append(aeroexpress_direction_link(from_point=station,
                                                          to_point=city,
                                                          template=FROM_AIRPORT_TO_CITY_TEMPLATE))

        else:
            content = [{
                'elem': 'item',
                'elemMods': {'icon': 'true'},
                'content': [{
                    'block': 'b-link',
                    'url': langify(get_station_url(kwargs={'sid': station.id})),
                    'mix': {'block': 'b-list', 'elem': 'item-text'},
                    'attrs': reach_goal_on(
                        action='click',
                        target='SELECT-STATION',
                        params={
                            'code': station.id,
                            'ttype': self.context.ttype
                        }
                    ),
                    'content': [
                        station.L_popular_title() or station.L_title(),
                        {
                            'block': 'b-list',
                            'elem': 'icon'
                        }
                    ]
                }]
            } for station in stations]

        return {
            'block': 'b-list',
            'content': [
                {
                    'elem': 'level',
                    'elemMods': {'stage': 'second'},
                    'content': content
                }
            ]
        }

    def content(self):
        return [
            {
                'elem': 'item',
                'content': [
                    {
                        'block': 'b-title',
                        'mods': {'type': 'select-transport'},
                        'content': self.context.title
                    },
                    self.transport_points()
                ]
            }
        ]


def aeroexpress_direction_link(from_point, to_point, template):
    params = {
        'aeroex': 'y',
        'fromName': from_point.L_title(),
        'fromId': from_point.point_key,
        'toName': to_point.L_title(),
        'toId': to_point.point_key
    }

    if from_point.L_title() == to_point.L_title():
        title = xgettext(template,
                         point_from=from_point.L_title,
                         point_to=to_point.L_title)

    else:
        title = '%s - %s' % (from_point.L_title(), to_point.L_title())

    return {
        'elem': 'item',
        'elemMods': {'icon': 'true'},
        'content': [{
            'block': 'b-link',
            'url': composeurl('search', kwargs={'search_type': 'suburban'}, params=params),
            'mix': {'block': 'b-list', 'elem': 'item-text'},
            'attrs': reach_goal_on(
                action='click',
                target='SELECT-AEROEXPRESS-DIRECTION',
                params={
                    'fromPoint': from_point.id,
                    'toPoint': to_point.id,
                }
            ),
            'content': [
                title,
                {
                    'block': 'b-list',
                    'elem': 'icon'
                }
            ]
        }]
    }


class DirectionsTemplate(Template):

    def transport_points(self):

        all_link = suburban_direction_link(url=composeurl('direction', params={'city': self.context.city.id}),
                                           title=gettext('Не знаю направление'),
                                           metrika_code='all')

        content = [all_link] + [suburban_direction_link(url=composeurl('direction', params={'direction': d.code}),
                                                        title=d.L_title(),
                                                        metrika_code=d.code) for d in self.context.directions]

        return {
            'block': 'b-list',
            'content': [
                {
                    'elem': 'level',
                    'elemMods': {'stage': 'second'},
                    'content': content
                }
            ]
        }


def suburban_direction_link(url, title, metrika_code):
    return {
        'elem': 'item',
        'elemMods': {'icon': 'true'},
        'content': [{
            'block': 'b-link',
            'url': url,
            'mix': {'block': 'b-list', 'elem': 'item-text'},
            'attrs': reach_goal_on(
                action='click',
                target='SELECT-SUBURBAN-DIRECTION',
                params={
                    'code': metrika_code
                }
            ),
            'content': [
                title,
                {
                    'block': 'b-list',
                    'elem': 'icon'
                }
            ]
        }]
    }
