import codecs
import os
import hemi
import settings
import logging

log = logging.getLogger(__name__)

bh_cache = {}
PATH_TO_STATIC = os.path.join(settings.PROJECT_PATH, 'static',)
PATH_TO_PRIVS = os.path.join(PATH_TO_STATIC, 'touch.bundles')


class BH(object):
    def __init__(self, path, page):
        self.page = page
        self.path = path
        self.bh = None
        self.i18n = None
        self.blocks = None
        self.stat = None

        self.load()

    def load(self):
        stat = os.stat(self.path)

        with codecs.open(self.path, 'r', encoding='utf-8') as f:
            source = f.read()

        context = hemi.Context()

        context.eval(source)

        self.bh = context.locals.bh
        self.i18n = context.locals.BEM.I18N
        self.blocks = context.locals.blocks

        self.stat = stat

    def apply(self, contract, lang):
        if settings.DEBUG and self.expired():
            self.load()

        self.i18n.lang(lang)

        try:
            bemjson = self.blocks.apply('b-page', contract, self.page)
        except TypeError, e:
            log.exception('TYPE_ERROR: contract={contract}'.format(contract=contract))
            raise e

        return self.bh.apply(bemjson)

    def expired(self):
        stat = os.stat(self.path)

        for attr in ['st_size', 'st_mtime']:
            if getattr(stat, attr) != getattr(self.stat, attr):
                return True

        return False


def render(page, contract, lang):
    path = os.path.join(PATH_TO_PRIVS, page, '%s.all.priv.js' % page)
    bh = bh_cache.get(path)

    if not bh:
        bh = bh_cache[path] = BH(path, page)

    if settings.DEBUG:
        rebuild_static(page)

    return bh.apply(contract, lang=lang)


def rebuild_static(page):
    with Cd(PATH_TO_STATIC):
        os.system(
            './node_modules/enb/bin/enb make touch.bundles/%s' % (
                page
            )
        )


class Cd:
    def __init__(self, newPath):
        self.newPath = newPath
        self.savedPath = os.getcwd()

    def __enter__(self):
        os.chdir(self.newPath)

    def __exit__(self, type, value, traceback):
        os.chdir(self.savedPath)
