# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import json
import logging
import urllib2

from django.conf import settings
from django.utils.translation import get_language
from pybreaker import CircuitBreaker

from common.utils import request_helper
from common.utils.http import urlopen
from common.settings.utils import define_setting


advert_log = logging.getLogger('advert')


define_setting('YABS_BREAKER_PARAMS', default={'fail_max': 3, 'reset_timeout': 60})

yabs_breaker = CircuitBreaker(**settings.YABS_BREAKER_PARAMS)


@yabs_breaker
def get_yabs_response(banner_request):
    return urlopen(banner_request, timeout=settings.BANNER_HTTP_TIMEOUT).read().strip().decode('cp1251')


def teaser_info(request):
    request = request
    url = 'https://yabs.yandex.ru/page/119?block-origin=1&banner-lang=%s' % get_language()

    headers = {
        'X-Real-IP': request.META['REMOTE_ADDR'],
        'X-Forwarded-For': request.META.get('HTTP_X_FORWARDED_FOR', ''),
        'User-Agent': request.META.get('HTTP_USER_AGENT', ''),
        'Cookie': request.META.get('HTTP_COOKIE', ''),
        'Referer': request_helper.build_absolute_uri(request),
    }

    banner_request = urllib2.Request(url, headers=headers)

    try:
        info = get_yabs_response(banner_request)
    except Exception:
        advert_log.error('Cannot load %r', url, exc_info=True)
        return

    try:
        parsed_info = json.loads(info)
    except Exception:
        advert_log.error('Cannot parse %r', info, exc_info=True)
        return

    try:
        teaser = parsed_info['ads']['teasers'][0]
    except (KeyError, IndexError):
        teaser = None

    if not teaser:
        advert_log.info('Empty response %r', info, exc_info=True)
        return

    img = teaser.get('img2') or teaser.get('img')

    if not img:
        return

    if 'url' not in teaser or 'text2' not in teaser:
        return

    text = teaser['text2']

    return {
        'text': text,
        'url': teaser['url'],
        'imageUrl': img['url'],
        'imageWidth': img['width']
    }
