# -*- coding: utf-8 -*-

from django.conf import settings

from common.utils.ya import get_passport_auth_url, get_passport_exit_url


def feedback_url(request):
    if request.tld == 'com.tr':
        return 'https://yandex.com.tr/support/common/feedback.xml'

    return 'https://yandex.ru/support/rasp/troubleshooting.xml?form1645-answer_short_text_25924=touch'


def user_agreement_url(request):
    return 'http://m.legal.yandex.%s/timetable_termsofuse/' % request.tld


def alternative_urls(request):
    query = request.get_full_path()

    if request.root_domain in {'by', 'kz', 'uz'}:
        alternatives = ['ru']
    else:
        alternatives = [request.root_domain]

    if request.root_domain == 'ru':
        alternatives += ['ua']
    if request.root_domain == 'ua':
        alternatives += ['ru']

    return [{'url': 'https://{0}{1}'.format(settings.NATIONAL_DOMAIN_MAP[root_domain], query),
             'lang': settings.DOMAIN_LANGUAGE_MAP[root_domain][0]}
            for root_domain in alternatives]


def auth_url(request):
    return (
        get_passport_exit_url(request)
        if request.yauser.is_authenticated() else
        get_passport_auth_url(request, 'rasp')
    )
