# -*- coding: utf-8 -*-

from __future__ import unicode_literals


def wrap_span(value):
    return {
        'elem': 'span',
        'tag': 'span',
        'content': value
    }


def wrap_link_item(value):
    return {
        'block': 'b-link',
        'elem': 'item',
        'content': value
    }


def wrap_time_in_path(value):
    return {
        'elem': 'span',
        'tag': 'span',
        'mix': [
            {
                'block': 'b-routers',
                'elem': 'time',
                'elemMods': {'type': 'in-path'}
            }
        ],
        'content': value
    }


def wrap_with(value, func):
    if not value:
        return ''

    parts = value.replace(u' - ', u' — ').split(u' ')

    return punctuate_content(map(func, parts), sep=u' ')


def wrap_with_time_in_path(value):
    return wrap_with(value, wrap_time_in_path)


def wrap_with_span_item(value):
    return wrap_with(value, wrap_span)


def wrap_with_link_item(value):
    return wrap_with(value, wrap_link_item)


def punctuate_content(content, sep=', '):
    punctuated_content = []

    iterator = iter(content)

    try:
        item = iterator.next()

    except StopIteration:
        return []

    while True:
        punctuated_content.append(item)

        try:
            item = iterator.next()

        except StopIteration:
            break

        punctuated_content.append(sep)

    return punctuated_content
