# -*- coding: utf-8 -*-

import logging
import urllib
from urlparse import urlsplit, urlunsplit

from django.conf import settings
from django.http import HttpResponseRedirect

from common.models.partner import Partner
from common.utils import marketstat
from common.utils.mysql_try_hard import mysql_try_hard
from common.xgettext.i18n import gettext
from common.utils import request_helper

from travel.rasp.touch.order.forms import OrderSegmentForm
from travel.rasp.touch.touch.core.templates.error import Template as ErrorTemplate


log = logging.getLogger(__name__)

redir_log = marketstat.Log(settings.REDIR_LOG)
auction_redir_log = marketstat.AuctionLog(settings.AUCTION_REDIR_LOG)


UFS_ORDER_URL = 'https://www.ufs-online.ru/kupit-zhd-bilety'
UFS_ADVERT = 3495
UFS_ADVERT_NAME = 'yandex-touch.ufs-online.ru'


def add_openstat_marker(request, partner, redirection):
    def add_marker(location):
        if partner in ['glavbilet', 'ufs', 'tickets_ua']:
            return location

        o = urlsplit(location)

        marker = u"ticket.yandex.ru;%s;Купить Авиабилет;%s" % (partner,request_helper.get_host())
        query = (o.query + '&' if o.query else '') + '_openstat=' + urllib.quote(marker.encode('utf-8'), safe='')

        return urlunsplit((o.scheme, o.netloc, o.path, query, o.fragment))

    if isinstance(redirection, HttpResponseRedirect):
        redirection["Location"] = add_marker(redirection["Location"])


def order_ufs(request, data):
    encoding = 'utf8'
    segment = data['segment']

    # Ну пусть будет местное
    railways_date = segment.departure.date()

    params = {
        'date': railways_date.strftime('%d.%m.%Y'),
        'trainNumber': data['choice']['number'].encode(encoding),
        'gotocar': data['choice'].get('car_type', u'').encode('utf-8'),
        'AdvertName': UFS_ADVERT_NAME,
        'DomainId': UFS_ADVERT,
    }

    mkl = data['choice'].get('MKL', None)
    if mkl:
        params['InternationalServiceClass'] = mkl.encode(encoding)

    url = "{root}/{from_id}/{to_id}?{params}".format(root=UFS_ORDER_URL,
                                                     params=urllib.urlencode(params),
                                                     from_id=segment.station_from.express_id,
                                                     to_id=segment.station_to.express_id)

    log.debug('UFS url: %s' % url)

    return HttpResponseRedirect(url)


def redirect_by_url(request, form_data):
    return HttpResponseRedirect(form_data['choice']['url'])


@mysql_try_hard
def main(request):
    order_form = OrderSegmentForm(request.GET)

    if not order_form.is_valid():
        return ErrorTemplate.render(request, {
            'page_title': gettext(u'Ошибка при переходе к партнеру'),
            'error': gettext(u'Ошибка при переходе к партнеру')
        }, show_calendar=False)

    data = order_form.cleaned_data

    partner = data['choice']['partner']

    redirect_function = globals().get('order_' + partner, redirect_by_url)
    redirection = redirect_function(request, data)

    if isinstance(redirection, HttpResponseRedirect):
        uri = redirection['Location']
    elif isinstance(redirection, tuple):
        uri, redirection = redirection
    else:
        uri = request_helper.build_absolute_uri(request)

    partner = Partner.objects.get(code=partner)

    redir_data = {
        'datasource_id': partner.billing_datasource_id,
        'price': str(partner.price.cents),
        'url': uri,
        'host': 'rasp'
    }

    redir_log.log(request, redir_data)
    auction_redir_log.log(request, {'show_id': ''})

    add_openstat_marker(request, data['choice']['partner'], redirection)

    return redirection

