# -*- coding: utf-8 -*-
from django.http import HttpResponseNotFound

from common.models.geo import Station
from common.models.schedule import Company
from common.utils.weather import weather_data

from travel.rasp.touch.touch.core.templates import info as info_tpl
from travel.rasp.touch.touch.core.templates.page import build_page
from travel.rasp.touch.touch.core.views.utils import get_attr_by_path


def station(request, sid):
    try:
        station = Station.objects.select_related('t_type', 'settlement').get(pk=sid)

    except Station.DoesNotExist:
        return HttpResponseNotFound()

    context = {
        'station': station,
        'phones': station.stationphone_set.all(),
        'page_title': station.L_info_title(),
        'weather': weather_data(request, station)
    }

    return info_tpl.StationTemplate.render(request, context)


def company(request, cid):
    try:
        company = Company.objects.get(pk=cid)

    except Company.DoesNotExist:
        return HttpResponseNotFound()

    # todo замочить после выкатки обновленной страницы в stable
    if 'showOldPage' in request.GET:
        context = {
            'company': company,
            'page_title': company.L_title()
        }

        return info_tpl.CompanyTemplate.render(request, context)

    view_contract = {
        'company': {
            'name': company.L_title(),
            'country': company.country and company.country.L_title(),
            'pngIconUrl': get_attr_by_path(company, 'icon.url', None),
            'svgIconUrl': get_attr_by_path(company, 'svg_logo.url', None),
            'codes': [c for c in[company.iata, company.sirena_id] if c],
            'contactInfo': company.contact_info,
            'url': company.url,
            'email': company.email,
            'phone': company.phone,
            'address': company.address
        },
        'pageTitle': company.L_title()
    }

    return build_page(request, 'company-card', view_contract=view_contract)


def main(request, object_type, object_id):
    if object_type == 'station':
        return station(request, object_id)

    return company(request, object_id)
