# -*- coding: utf-8 -*-

from django.conf import settings
from django.conf.urls import url, include

from common.views.version import version

from travel.rasp.touch.touch.core.views.buy import main as buy_main
from travel.rasp.touch.touch.core.views.city import CityView, stations, directions
from travel.rasp.touch.touch.core.views.direction import main as direction_main, search as direction_search, ajax_direction_stations
from travel.rasp.touch.touch.core.views.info import main as info_main
from travel.rasp.touch.touch.core.views.search.search import ajax_tariffs
from travel.rasp.touch.touch.core.views.search.thread import main as search_thread_main
from travel.rasp.touch.touch.core.views.thread import buy_info, avia_buy_info, main
from travel.rasp.touch.touch.core.views.validate import validate
from travel.rasp.touch.touch.core.views import handler403, handler500


urlpatterns = [
    url(r'^$', CityView.as_view()),

    url(r'^tariffs/(?P<search_type>plane|train|suburban|bus|sea|river|water|all)/$', ajax_tariffs, name='tariffs'),

    url(r'^stations/(?P<ttype>plane|bus|train|sea|river|water)/$', stations, name='stations'),

    url(r'^thread/buy/$', buy_info, name='buy_info'),
    url(r'^thread/(?P<uid>[-\w*]+)/avia/buy/$', avia_buy_info, name='avia_buy_info'),
    url(r'^thread/buy/redirect/$', buy_main, name='buy_order'),
    url(r'^thread/(?P<uid>[-\w*]+)/$', main, name='thread'),

    url(r'^info/(?P<object_type>station|company)/(?P<object_id>\d+)\/?$', info_main, name='info'),

    url(r'^suburban-directions/$', directions, name='directions'),

    url(r'^direction/$', direction_main, name='direction'),
    url(r'^direction-search/$', direction_search, name='direction_search'),
    url(r'^direction_stations/(?P<direction>[-\w\*_]+)/$', ajax_direction_stations),

    url(r'^search-threads/$', search_thread_main, name='search_threads'),

    url(r'^form-validate/$', validate),

    url(r'^500/$', handler500),
    url(r'^403/$', handler403),

    #Редиректы
    url(r'', include('travel.rasp.touch.redirects.urls'))
] + [url(r'^version/$', version)]

if getattr(settings, 'USE_LOCAL_STATIC', False):
    from django.conf.urls.static import static
    urlpatterns = urlpatterns + static('/markup/', document_root=settings.STATIC_ROOT)
