# -*- coding: utf-8 -*-


def station_ttype_codes(station):
    type_list = station.type_choices.split(',')

    if not station.tablo_state:
        type_list = [t for t in type_list if t != 'tablo']

        if station.t_type.code == 'plane':
            type_list.insert(0, 'plane')

    if not station.has_aeroexpress:
        type_list = [t for t in type_list if t != 'aeroex']

    return type_list


def get_station_url(kwargs):
    if 'type_code' in kwargs:
        return '/station/{}/{}'.format(kwargs['sid'], kwargs['type_code'])
    else:
        return '/station/{}'.format(kwargs['sid'])
