PY2_LIBRARY()

OWNER(g:rasp-back)

PEERDIR(
    metrika/uatraits/python

    contrib/python/ipython
    travel/library/python/entrypoint

    travel/library/python/resource

    travel/rasp/library/python/common
    travel/rasp/library/python/common_old
    travel/rasp/library/python/geosearch
    travel/rasp/library/python/mapping
    travel/rasp/library/python/route_search
    travel/rasp/library/python/stationschedule
    travel/rasp/library/python/url_mapper
    travel/rasp/library/python/hemi
)

PY_SRCS(
    TOP_LEVEL
    docker/local_settings.py
    gunicorn_conf.py
    settings.py
)

PY_SRCS(
    forms/__init__.py
    forms/city.py
    forms/search.py
    modelBuilders/__init__.py
    modelBuilders/thread/__init__.py
    modelBuilders/thread/thread_graphic.py
    order/__init__.py
    order/forms.py
    order/models/__init__.py
    order/models/coachservice.py
    order/views/__init__.py
    order/views/train/__init__.py
    order/views/train/base.py
    order/views/train/ufs.py
    redirects/__init__.py
    redirects/urls.py
    redirects/views.py
    tariffs/__init__.py
    tariffs/bus.py
    tariffs/partners/__init__.py
    tariffs/partners/allticketsfor_me.py
    tariffs/partners/main.py
    tariffs/partners/utisauto.py
    tariffs/retrieving/__init__.py
    tariffs/retrieving/base.py
    tariffs/retrieving/ufs.py
    tariffs/settings.py
    tariffs/utils.py
    tariffs/views.py
    tools/__init__.py
    tools/bullets/__init__.py
    tools/bullets/company.py
    tools/lint.py
    touch/__init__.py
    touch/app.py
    touch/core/__init__.py
    touch/core/helpers/__init__.py
    touch/core/helpers/alternate_domains.py
    touch/core/helpers/blablacar.py
    touch/core/helpers/station.py
    touch/core/helpers/thread.py
    touch/core/helpers/transport_type.py
    touch/core/lib/__init__.py
    touch/core/lib/train_number.py
    touch/core/lib/train_tariff_api_client.py
    touch/core/lib/train_tariff_key_map_fabric.py
    touch/core/templates/__init__.py
    touch/core/templates/base.py
    touch/core/templates/blocks/__init__.py
    touch/core/templates/blocks/buy_avia_ticket.py
    touch/core/templates/blocks/buy_train_ticket.py
    touch/core/templates/blocks/companyIcon.py
    touch/core/templates/blocks/metrika.py
    touch/core/templates/blocks/switcher.py
    touch/core/templates/blocks/tariffPrice.py
    touch/core/templates/city.py
    touch/core/templates/direction.py
    touch/core/templates/elements/__init__.py
    touch/core/templates/elements/lineInfo.py
    touch/core/templates/error.py
    touch/core/templates/form.py
    touch/core/templates/info.py
    touch/core/templates/message.py
    touch/core/templates/page.py
    touch/core/templates/parts.py
    touch/core/templates/precise.py
    touch/core/templates/search/__init__.py
    touch/core/templates/search/search.py
    touch/core/templates/search/stations.py
    touch/core/templates/search/threads.py
    touch/core/templates/search/untypedSearch.py
    touch/core/templates/station/__init__.py
    touch/core/templates/station/schedule.py
    touch/core/templates/stations.py
    touch/core/templates/thread.py
    touch/core/templates/utils/__init__.py
    touch/core/templates/utils/bh.py
    touch/core/templates/utils/desktop_links.py
    touch/core/templates/utils/favicons.py
    touch/core/templates/utils/tizer.py
    touch/core/templates/utils/touch_links.py
    touch/core/templates/utils/wrappers.py
    touch/core/views/__init__.py
    touch/core/views/buy.py
    touch/core/views/city.py
    touch/core/views/direction.py
    touch/core/views/info.py
    touch/core/views/search/__init__.py
    touch/core/views/search/search.py
    touch/core/views/search/thread.py
    touch/core/views/teasers.py
    touch/core/views/thread.py
    touch/core/views/utils.py
    touch/core/views/validate.py
    touch/tests/__init__.py
    touch/tests/lib/__init__.py
    touch/tests/lib/test_tariff_train_api.py
    touch/tests/lib/test_train_number.py
    touch/tests/lib/test_train_tariff_key_map_fabric.py
    touch/urls.py
    touch/utils.py
    touch/wsgi.py
)

RESOURCE_FILES(
    keysets/common_keysets/datetemplates-keyset.json
    keysets/common_keysets/days-keyset.json
    keysets/common_keysets/months-keyset.json
    keysets/common_keysets/schedule_autotexts-keyset.json
    keysets/keyset.json
)

END()

RECURSE(
    bin
    markup_package
)

RECURSE_FOR_TESTS(
    bin/tests
)

