# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import sys

from travel.library.python.entrypoint import default_run, gunicorn_base, manage

__all__ = [
    'manage',  # used as Y_PYTHON_ENTRY_POINT="travel.rasp.train_api.app:manage"
]


def gunicorn():
    from travel.rasp.train_api import wsgi_async
    gunicorn_base(wsgi_async.application)


def celery():
    from celery import maybe_patch_concurrency

    if 'multi' not in sys.argv:
        maybe_patch_concurrency()

    from celery.bin.celery import main as _main
    _main()


SCRIPTS = {
    'export_data_for_google_ads': 'travel.rasp.train_api.scripts.export_data_for_google_ads.export_data_for_google_ads_task',
    'export_orders_and_refunds': 'travel.rasp.train_api.scripts.export_orders_and_refunds.main',
    'restart_application': 'travel.rasp.train_api.scripts.restart_application.main',
    'archive_order_logs': 'travel.rasp.train_api.scripts.ydb.archive_logs.run'
}


def script():
    import django
    django.setup()

    from django.utils.module_loading import import_string

    from common.db.switcher import switcher
    switcher.sync_db()

    if len(sys.argv) < 2:
        raise NotImplementedError('Specify script name')

    script_name = sys.argv[1]
    if script_name not in SCRIPTS:
        raise NotImplementedError("Don't know script '{}'".format(script_name))

    script_path = SCRIPTS[script_name]
    try:
        script_run_function = import_string(script_path)
    except ImportError:
        raise NotImplementedError("Can't find function '{}'".format(script_path))
    else:
        sys.argv = sys.argv[1:]
        script_run_function()


if __name__ == '__main__':
    default_run(globals())
