# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

"""
Минимально необходимые настройки Celery - как для воркеров, так и для кода, отправляющего таски.
"""
import logging
import os

from celery import Celery

from common.celery.worker import PatchedConsumer

log = logging.getLogger(__name__)


class SignalingPatchedConsumer(PatchedConsumer):
    def on_connection_error_after_connected(self, exc):
        log.error("Signaling due connection error")
        with open('/tmp/train_api_critical_error', 'w'):
            pass


app = Celery('morda_backend')
app.config_from_object('django.conf:settings', namespace='CELERY')
app.conf.update({
    'worker_consumer': SignalingPatchedConsumer,
    # 'worker_concurrency': os.getenv('CELERY_CONCURRENCY', 50),
    # 'worker_pool': os.getenv('CELERY_POOL', 'gevent'),
    'worker_max_tasks_per_child': os.getenv('CELERY_MAX_TASKS_PER_CHILD', 1000)
})
app.autodiscover_tasks(['common.workflow', 'travel.rasp.train_api.train_purchase.tasks'])
