# coding: utf-8
# flake8: noqa
from __future__ import absolute_import, unicode_literals

# Для мониторинга статуса компонента celery в qloud создается thread, в котором
# запускается сервер, который отвечает на /ping
# При этом при одновременном логировании из запущенного сервера и масер процесса и форков
# внутри модуля logging используются одинаковые локи, что приводит к деадлоку.
# Баг в python https://bugs.python.org/issue6721,
# который возникает при одновременном использовании logging, threading и fork.
# Для починки нашего приложения нужно отключить логирование из http-сервера.
from travel.rasp.train_api.monkey_patch_flask import disable_flask_logging  # noqa
disable_flask_logging()  # noqa

import django
django.setup()  # noqa

import logging
import threading

from celery.schedules import crontab
from celery.signals import worker_init, task_prerun, celeryd_after_setup, beat_init
from django.conf import settings
from flask import Flask

from common.db.mongo import ConnectionProxy
from common.db.switcher import switcher
from common.utils.dcutils import ResourceExplorer
from travel.rasp.train_api.celery.app import app
from travel.rasp.train_api.train_purchase.tasks.revivers import REVIVE_FREQUENCY
import travel.rasp.train_api.train_purchase.tasks.check_office_refunds  # noqa

log = logging.getLogger(__name__)


# Внимание! Время в UTC
app.conf.beat_schedule = {
    'ticket_refund_reviver': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.revivers.revive_ticket_refund_processes',
        'schedule': REVIVE_FREQUENCY,
    },
    'booking_reviver': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.revivers.revive_train_booking_processes',
        'schedule': REVIVE_FREQUENCY,
    },
    'payment_reviver': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.revivers.revive_train_payment_processes',
        'schedule': REVIVE_FREQUENCY,
    },
    'update_client_contracts': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.client_contracts.update_billing_client_contracts',
        'schedule': crontab(hour='*/8', minute=30),
    },
    'create_trust_products': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.trust_products.create_partners_and_products',
        'schedule': 30 * 60.0,
    },
    'collect_outdated_refund_blanks': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.collect_refund_blanks.collect_outdated_refund_blanks',
        'schedule': crontab(minute='*'),
    },
    'retry_refund_payment': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.finish_refund_payment.retry.retry_refund_payment',
        'schedule': crontab(minute=25),
    },
    'update_refund_payment_status': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.finish_refund_payment.'
                'update_from_billing.update_refund_payment_status',
        'schedule': crontab(minute=35),
    },
    'send_failed_refund_payment_email': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.finish_refund_payment.'
                'send_fail_email.send_failed_refund_payment_email',
        'schedule': crontab(minute=45),
    },
    'close_refund_email_intents': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.refund_email.close_refund_email_intents',
        'schedule': crontab(minute='*/5')
    },
    'run_email_queue': {
        'task': 'common.email_sender.tasks.run_queue',
        'schedule': crontab(minute='*'),
    },
    'unhold_invalid_payments': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.unhold_invalid_payments.unhold_payments',
        'schedule': crontab(minute='*/10'),
    },
    'check_im_office_refunds': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.check_office_refunds.check_im_office_refunds',
        'schedule': crontab(minute=0, hour='11,14'),
    },
    'fill_payment_status_and_response': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.fill_payment_status_and_response.fill_billing_status_and_response',
        'schedule': crontab(minute=0, hour='1,5,9,13,17,21'),
    },
    'clear_payments': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.clear_payments.start_clear_payments',
        'schedule': crontab(minute='*/15'),
    },
    'collect_expired_orders': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.collect_expired_orders.set_orders_expired',
        'schedule': crontab(minute='*/2'),
    },
    'process_unhandled_exception_orders': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.unhandled_exception_order.process_unhandled_exception_orders',
        'schedule': crontab(minute='*/2'),
    },
    'process_unhandled_exception_refund': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.unhandled_exception_refund.process_unhandled_exception_refund',
        'schedule': crontab(minute='*/10'),
    },
    'send_long_external_event_email': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.long_external_event_email.send_long_external_event_email',
        'schedule': crontab(minute='*/2'),
    },
    'check_im_balance': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.check_balance.check_im_balance',
        'schedule': crontab(minute='*/30'),
    },
    'clean_limiter': {
        'task': 'travel.rasp.train_api.train_purchase.tasks.clean_limiter.do_clean_tokens',
        'schedule': crontab(minute='*'),
    },
}


@task_prerun.connect
def sync_db(**kwargs):
    switcher.sync_with_lazy_reconnect()


@worker_init.connect
def close_mongo_connections(**kwargs):
    ConnectionProxy.close_connections()


flask_app = Flask(__name__)


@flask_app.route('/ping')
def ping():
    if settings.CHECK_DB_IN_PING:  # проверяем живость базы
        from django.db import connection
        connection.cursor().execute("select * from flags;")
    return 'pong\n'


class StatusCheckerThread(threading.Thread):
    def run(self):
        flask_app.run(host='::1', port=8888, load_dotenv=False)


def run_status_check(*args, **kwargs):
    if ResourceExplorer.is_run_in_qloud() or ResourceExplorer.is_run_in_deploy():
        status_checker = StatusCheckerThread()
        status_checker.daemon = True
        status_checker.start()


celeryd_after_setup.connect(run_status_check)
beat_init.connect(run_status_check)
