# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.data_api.search_stats import search_stats
from common.models.geo import Settlement
from common.models_utils.geo import Point


def get_popular_directions(settlement_id):
    """
    Получает популярные направления на основе статистики поисковых запросов.
    """
    settlement = Settlement.objects.get(id=settlement_id)
    top_from_pairs = search_stats.search_stats.get_top_from(settlement.point_key, 'all', 'c', limit=10)
    top_to_pairs = search_stats.search_stats.get_top_to(settlement.point_key, 'all', 'c', limit=10)
    return {
        'from': {
            'title': settlement.L_title_phrase_from(),
            'points': get_settlements(top_from_pairs)
        },
        'to': {
            'title': settlement.L_title_phrase_to(),
            'points': get_settlements(top_to_pairs)
        }
    }


def get_settlements(top_pairs):
    point_keys = [point_key for (point_key, count) in top_pairs]
    points_dict = Point.in_bulk(point_keys)
    return [points_dict[point_key] for point_key in point_keys if point_key in points_dict]
