#!/usr/bin/env python2
# coding: utf8
from __future__ import absolute_import, division, print_function

from nginx_log_normalize_functions import nginx_log_normalize_uri

# Если в регулярке есть исключающие символы, заводим как кортеж, иначе просто как строку
paths = [
    r'api/segments/train-tariffs/poll/',
    r'api/segments/train-tariffs/',

    r'api/cpa/orders-with-refunds/',
    r'api/cpa/orders/',

    r'train-purchase-backoffice/',

    r'api/active-partners/',
    r'api/user-orders/',
    r'api/download-blank/',
    r'api/calculate-refund-amount/',
    r'api/update-tickets-status/',
    r'api/change-registration-status/',
    r'api/ufs-train-details/',
    r'api/train-details/',
    r'api/internal/train-details/'
    r'api/partner-schedule/',
    r'api/order-tickets/',
    r'api/segments/min-tariffs/',
    r'api/train-popular-directions/',
    r'api/search/train-segment/',
    r'api/takeout-orders/',
    r'api/travel/order-auth-details/',
    r'api/travel/calculate-tickets-fee/',
    r'api/train-purchase/orders/find/',
    (r'api/train-purchase/orders/(.+?)/cancel/', 'api/train-purchase/orders/uid/cancel/'),
    (r'api/train-purchase/orders/(.+?)/refund/', 'api/train-purchase/orders/uid/refund/'),
    (r'api/train-purchase/orders/(.+?)/retry_payment/', 'api/train-purchase/orders/uid/retry_payment/'),
    (r'api/train-purchase/orders/(.+?)/run_booking/', 'api/train-purchase/orders/uid/run_booking/'),
    (r'api/train-purchase/orders/(.+?)/retrieve/', 'api/train-purchase/orders/uid'),
    (r'api/train-purchase/orders/(.+?)/', 'api/train-purchase/orders/uid'),
    (r'api/train-purchase/orders/insurance/(.+?)/checkout/', 'api/train-purchase/orders/insurance/uid/checkout/'),
]


def nginx_log_normalize_path(uri):
    lang_prefix = r'^/([a-z]+)/'
    return nginx_log_normalize_uri(paths, uri, lang_prefix)
