# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import gc
import os

from travel.rasp.library.python.common23.server.gunicorn.mongo_control import pre_fork as pre_fork_mongo  # noqa

from jaeger_client import Config
from travel.library.python.gunicorn.worker_watcher import WorkersWatcher
from travel.library.python.tracing.django import Tracing
from travel.library.python.tracing.gunicorn import build_post_fork
from travel.library.python.solomon.server import SolomonMetricsServer
from travel.rasp.train_api.pb_provider import PROTOBUF_DATA_PROVIDER


watcher = WorkersWatcher()
solomon = SolomonMetricsServer()
preload_app = True


def on_reload(server):
    from common.precache.backend import setup_precache
    setup_precache(logger=server.log)


def on_starting_precache(server):
    from common.precache.backend import setup_precache
    setup_precache(logger=server.log)


def pre_fork_precache(server, worker):
    # Закрываем соединение, чтобы не передавать воркерам копию сокета [RASPWIZARDS-175]
    from django.core.cache import cache
    cache.close()


def pre_fork(server, worker):
    from django.conf import settings

    pre_fork_precache(server, worker)
    pre_fork_mongo(server, worker)
    watcher.pre_fork(server, worker)

    if settings.TRAIN_API_LOAD_PROTOBUFS:
        PROTOBUF_DATA_PROVIDER.load_from_dir(settings.PROTO_DIR)

    # собираем мусор, чтобы не оставлять его в форках
    gc.collect()


def child_exit(server, worker):
    watcher.child_exit(server, worker)


def on_starting(server):
    on_starting_precache(server)
    watcher.on_starting(server)

    solomon.register_gauge({'sensor': 'requests_in_work'}, watcher.get_requests_in_work_count)
    solomon.register_gauge({'sensor': 'requests_in_work_max'}, watcher.get_max_requests_in_work)
    solomon.run_in_thread()


bind = 'unix:/tmp/yandex-rasp-morda-backend-gunicorn-async.sock'
limit_request_line = 8190
max_requests = int(os.getenv('MAIN_ENVIRONMENT_MAX_REQUESTS', 10000))
threads = int(os.getenv('MAIN_ENVIRONMENT_THREADS_COUNT', 15))
max_requests_jitter = int(os.getenv('MAIN_ENVIRONMENT_MAX_REQUESTS_JITTER', 2000))
worker_class = os.getenv('MAIN_ENVIRONMENT_WORKERS_CLASS',
                         'travel.library.python.gunicorn.worker_watcher.workers.ThreadWorker')
workers = int(os.getenv('MAIN_ENVIRONMENT_WORKERS_COUNT', 3))
timeout = int(os.getenv('MAIN_ENVIRONMENT_WORKER_TIMEOUT', 30))
worker_connections = int(os.getenv('MAIN_ENVIRONMENT_WORKER_CONNECTIONS', 1000))

jaeger_sampler_type = os.environ.get('JAEGER_SAMPLER_TYPE', 'probabilistic')
jaeger_sampler_parameter = float(os.environ.get('JAEGER_SAMPLER_PARAMETER', 0.001))
jaeger_config = Config(
    config={
        'sampler': {
            'type': jaeger_sampler_type,
            'param': jaeger_sampler_parameter,
        },
        'logging': False,
    },
    service_name='train-api',
    validate=True,
)

post_fork = build_post_fork(jaeger_config, wrapper_cls=Tracing)
