# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import requests
from decimal import Decimal
from django.conf import settings

from common.settings.configuration import Configuration
from common.settings.utils import define_setting

define_setting('BUNKER_URL', {Configuration.PRODUCTION: u'http://bunker-api.yandex.net/'},
               default=u'http://bunker-api-dot.yandex.net/')


def get_node(path, timeout=1):
    url = settings.BUNKER_URL + u'v1/cat?node=' + path
    return requests.get(url, timeout=timeout)


def get_mock_raw_data(mock_im_path):
    return get_node(mock_im_path).json(parse_float=Decimal)
