from __future__ import unicode_literals, absolute_import, division, print_function


class ExpMap(object):
    def __init__(self, exp_map):
        self._exp_map = ExpMap._parse_exp_map(exp_map)

    @staticmethod
    def _parse_exp_map(exp_map_str):
        exp_map = {}
        if not exp_map_str:
            return exp_map
        for key, val in (entry.split(':') for entry in exp_map_str.split(';') if ':' in entry):
            if key in exp_map:
                raise ValueError('multiple entrance of key {}'.format(key))
            exp_map[key] = val
        return exp_map

    def get_exp_value_from_exp_boxes(self, expboxes_str):
        expboxes = ExpMap._parse_expboxes(expboxes_str)
        results = {self._exp_map.get(test_id) for test_id in expboxes if test_id in self._exp_map}
        if not results:
            return None
        if len(results) > 1:
            raise ValueError('found many testIds from expmap')
        return results.pop()

    @staticmethod
    def _parse_expboxes(expboxes_str):
        if not expboxes_str:
            return []
        test_ids = [entry.split(',')[0] for entry in expboxes_str.split(';') if entry]
        return test_ids
