# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function


def fix_list_subfactory(name, subfactory_class, params):
    """
    Позволяет для вложенного списка передавать только нужные аргументы,
    которые пойдут в соответствующую SubFactory.

    class SomeFactory(factory.Factory):
        some_field = factory.List([factory.SubFactory(SomeSubFactory)])

        @classmethod
        def create(cls, **kwargs):
            fix_list_subfactory('some_field', SomeSubFactory, kwargs)
            return super(SomeFactory, cls).create(**kwargs)

    def test_something()
        SomeFactory(some_field=[{'k': 'v', 'k2': 'v2'}, {'k3': 'v3'}, {}, SomeSubFactory(k4=v4)]
        ...
    """
    if name in params:
        values = []
        for value in params[name]:
            if isinstance(value, subfactory_class):
                values.append(value)
            else:
                values.append(subfactory_class(**value))
        params[name] = values
