# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.train_api.helpers.data_converter import to_int


def get_national_version(request):
    return request.GET.get('national_version') or 'ru'


def get_int_param_value(request, param_name):
    return to_int(request.GET.get(param_name))


def get_int_list_param_value(request, param_name):
    values = request.GET.get(param_name)
    if values is None:
        return None

    values = values.split(',')
    values = [to_int(value) for value in values]
    values = [value for value in values if value is not None]

    return values
