from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
import ydb
from rasp_vault.api import get_secret

from common.settings.configuration import Configuration
from common.settings.utils import define_setting

define_setting('YDB_TOKEN', default=get_secret('rasp-robot-tokens-and-passwords.yql-token'))
define_setting('YDB_ENDPOINT', {
    Configuration.PRODUCTION: 'ydb-ru.yandex.net:2135',
    Configuration.TESTING: 'ydb-ru-prestable.yandex.net:2135',
    Configuration.DEVELOPMENT: 'ydb-ru-prestable.yandex.net:2135',
    Configuration.STRESS: 'ydb-ru-prestable.yandex.net:2135',
})
define_setting('YDB_DATABASE', {
    Configuration.PRODUCTION: '/ru/railway/production/train_purchase',
    Configuration.TESTING: '/ru-prestable/railway/testing/train_purchase',
    Configuration.DEVELOPMENT: '/ru-prestable/railway/development/train_purchase',
    Configuration.STRESS: '/ru-prestable/railway/stress/train_purchase',
})


class YdbProvider(object):
    def __init__(self, endpoint=settings.YDB_ENDPOINT, database=settings.YDB_DATABASE, auth_token=settings.YDB_TOKEN):
        self.connection_params = ydb.DriverConfig(
            endpoint=endpoint, database=database, auth_token=auth_token
        )
        self._driver = None

    def get_session(self):
        driver = self.get_driver()
        return driver.table_client.session().create() if driver else None

    def get_driver(self):
        if not self._driver:
            self._driver = self._create_ydb_driver()
        return self._driver

    def _create_ydb_driver(self):
        try:
            _driver = ydb.Driver(self.connection_params)
            _driver.wait(timeout=10)
        except Exception as ex:
            _driver = None
            print(ex)
        return _driver


ydb_provider = YdbProvider()
