# coding: utf-8
# flake8: noqa
from __future__ import unicode_literals, absolute_import, division, print_function

import os
import pprint
from collections import defaultdict
from datetime import datetime

import six

from common import activate_this  # noqa
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'local_settings')  # noqa
import django
django.setup()  # noqa

from common.apps.train.models import TariffInfo
from common.apps.train_order.enums import CoachType
from common.models.geo import Station, Country
from common.utils import gen_hex_uuid
from common.utils.date import MSK_TZ
from morda_backend.train_partners import get_partner_api
from morda_backend.train_purchase.core.enums import AgeGroup, Gender, GenderChoice
from morda_backend.train_purchase.core.factories import ClientContractFactory
from morda_backend.train_purchase.core.models import TrainPartner, DocumentType, OrderStatus
from morda_backend.train_partners.im.base import get_im_response
from morda_backend.train_purchase.utils.order_tickets import create_order


def reserve_order(num_of_passegens=1):
    partner_api = get_partner_api(TrainPartner.IM)
    request = partner_api.ReserveRequest(
        arrival_point_code='2004001',  # Питер, Московский вокзал,
        bedding=False,
        coach_number='06',
        coach_type=CoachType.PLATZKARTE,
        departure_point_code='2006004',  # Москва, Питерский вокзал,
        electronic_registration=True,
        gender=None,
        places_option=None,
        service_class='3У',
        train_number='030А',
        when=datetime(2017, 11, 10, 1, 15),
    )

    for i in range(num_of_passegens):
        request.add_passenger(
            age_group=AgeGroup.ADULTS,
            birth_date=datetime(1990, 1, 1 + i),
            citizenship_country=Country.objects.get(pk=Country.RUSSIA_ID),
            document_number=('1' + six.text_type(i)) * 5,
            document_type=DocumentType.RUSSIAN_PASSPORT,
            first_name='Иван',
            gender=Gender.MALE,
            last_name='Иванов',
            loyalty_cards=[],
            patronymic='Иванович',
            tariff_info=TariffInfo.objects.get(code=TariffInfo.FULL_CODE)
        )

    return request.send()


def create_order_from_result(reservation_result):
    order_data = {
        'departure': MSK_TZ.localize(datetime(2017, 11, 10, 1, 15)),
        'station_from': Station.get_by_code('express', '2006004'),
        'station_to': Station.get_by_code('express', '2004001'),
        'arrival': MSK_TZ.localize(datetime(2017, 11, 10, 10, 23)),
        'coach_number': '06',
        'coach_type': CoachType.PLATZKARTE,
        'gender': GenderChoice.MIXED,
        'partner': TrainPartner.IM,
        'train_number': '030А',
        'train_ticket_number': '030А',
        'user_info': {
            'ip': '127.0.0.1',
            'uid': '2223444',
            'region_id': 1,
            'email': '{}@yandex-team.ru'.format(os.environ['USER'])
        },
        'bedding': False
    }
    order_uid = gen_hex_uuid()
    return create_order(order_uid, order_data, reservation_result, ClientContractFactory())


def confirm_order(order):
    params = {
        'OrderId': order.current_partner_data.im_order_id,
        'OrderCustomerIds': None,
        'OrderCustomerDocuments': None,
        'ProviderPaymentForm': 'Card'
    }
    response = get_im_response('Order/V1/Reservation/Confirm', params=params)
    order.current_partner_data.operation_id = str(response['ConfirmResults'][0]['OrderItemId'])
    order.status = OrderStatus.DONE

    return response


def get_order_info(order):
    return get_im_response('Order/V1/Info/OrderInfo', params={
        'OrderId': order.current_partner_data.im_order_id,
    })


def get_return_amount(doc_number, item_id, blank_ids):
    return get_im_response('Order/V1/Reservation/ReturnAmount', params={
        'ServiceReturnAmountRequest': {
            '$type': 'ApiContracts.Railway.V1.Messages.Return.RailwayReturnAmountRequest, ApiContracts',
            'OrderItemBlankIds': blank_ids,
            'CheckDocumentNumber': doc_number,
            'OrderItemId': item_id
        }
    })


def get_blank_ids(conf_result):
    result = defaultdict(list)
    for cr in conf_result['ConfirmResults']:
        for blank in cr['Blanks']:
            result[cr['OrderItemId']].append(blank['OrderItemBlankId'])
    return result


if __name__ == '__main__':
    reserve_result = reserve_order(1)
    order = create_order_from_result(reserve_result)

    confirm_result = confirm_order(order)

    order_info = get_order_info(order)
    print('order_info is')
    pprint.pprint(order_info)

    # item_id = blank_ids.keys()[0]
    # blank_ids_to_return = blank_ids[item_id]
    # return_amount = get_return_amount(order.passengers[0].doc_id, item_id, blank_ids_to_return)
    # print 'return amount is'
    # pprint.pprint(return_amount)
