# coding: utf-8
"""
Все настройки проекта автоматически определяются в соответствии с типом окружения
(production/testing/stress/development). Тип окружения определяется либо пакетом yandex-environment-{type},
тогда код смотрит на файлик /etc/yandex/environment.type, или через переменные окружения: YENV_TYPE и YENV_NAME.

Большая часть зависящих от окружения настроек сгруппирована в конфигураторы (их можно найти в
common.settings.configuration), не зависящие от окружения просто импортируются из модулей в common.settings.*.
Специфичные для проекта настройки можно найти в settings.py

Все настройки можно переопределить как то так:

    # mysql
    DATABASES['default']['USER'] = 'root'
    DATABASES['default']['PASSWORD'] = 'rasp'  # пароль rasp используется по умолчанию
                                               # (см. common.settings.configuration.mysql)
    TEST_DB_NAME = 'rasp_test'


    # mongo
    MONGO_DATABASES['default']['db'] = 'rasp'
    MONGO_DATABASES['default']['user'] = ''
    MONGO_DATABASES['default']['password'] = ''
    MONGO_DATABASES['train_purchase']['db'] = 'rasp'
    MONGO_DATABASES['train_purchase']['user'] = ''
    MONGO_DATABASES['train_purchase']['password'] = ''
    TEST_MONGO_DB = 'rasp_test'


"""
from __future__ import unicode_literals, absolute_import, division, print_function

from settings import *  # noqa
